require 'tk';
require 'chunky_png';
require 'tkextlib/tile';
require 'tkextlib/tkimg';
root = TkRoot.new;
root.title  = 'Cote of Arms Demo';

TkGrid.columnconfigure root, 0, :weight => 1; 
TkGrid.rowconfigure root, 0, :weight => 1;

#-- Global Variables Declaration

$CT = Time.new;
$Groupname = TkVariable.new;

$image0 = TkPhotoImage.new('file'=>"Images/CoatOfArmsShrunk.png");
$BoarIcon = TkPhotoImage.new('file'=>"Images/Charge Icons/BoarIcon.png");
$GriffonIcon = TkPhotoImage.new('file'=>"Images/Charge Icons/GriffinIcon.png");
$TigerIcon = TkPhotoImage.new('file'=>"Images/Charge Icons/TigerIcon.png");
$StagIcon = TkPhotoImage.new('file'=>"Images/Charge Icons/StagIcon.png");
$SpiderIcon = TkPhotoImage.new('file'=>"Images/Charge Icons/SpiderIcon.png");
$TrefoilIcon = TkPhotoImage.new('file'=>"Images/Charge Icons/TrefoilIcon.png");

$Button_Height = TkVariable.new;
$Button_Width = TkVariable.new;
$Button_Borderwidth = TkVariable.new;

$Screen_Height = TkVariable.new;

$Motto_Entry_Length = TkVariable.new;

$Description = TkVariable.new;
$Description_Summary = TkVariable.new;
	$Description_Summary_gold = TkVariable.new;
	$Description_Summary_silver = TkVariable.new;
	$Description_Summary_red = TkVariable.new;
	$Description_Summary_blue = TkVariable.new;
	$Description_Summary_black = TkVariable.new;
	$Description_Summary_green = TkVariable.new;

$Charge_Summary = TkVariable.new;
		$Charge_Summary_boar = TkVariable.new;
		$Charge_Summary_griffon = TkVariable.new;
		$Charge_Summary_trefoil = TkVariable.new;
		$Charge_Summary_stag = TkVariable.new;
		$Charge_Summary_spider = TkVariable.new;
		$Charge_Summary_tiger = TkVariable.new;

$Shield_Colour = TkVariable.new;
	$Shield_Yellow = TkVariable.new;
	$Shield_Silver = TkVariable.new;
	$Shield_Red = TkVariable.new;
	$Shield_Blue = TkVariable.new;
	$Shield_Black = TkVariable.new;
	$Shield_Green = TkVariable.new;

$Charge = TkVariable.new;
		$ChargeBoar = TkVariable.new; 
		$ChargeGriffon = TkVariable.new; 
		$ChargeTrefoil = TkVariable.new; 
		$ChargeStag = TkVariable.new;
		$ChargeSpider = TkVariable.new;
		$ChargeTiger = TkVariable.new;
	
$Charge_Colour = TkVariable.new;
		$Charge_Yellow = TkVariable.new; 
		$Charge_Silver = TkVariable.new;
		$Charge_Red = TkVariable.new; 
		$Charge_Blue = TkVariable.new;
		$Charge_Black = TkVariable.new;	
		$Charge_Green = TkVariable.new;
		
$Label_Height = TkVariable.new;	
$Summary_Height = TkVariable.new;
$Description_Label_Height = TkVariable.new;	
$Image_Label_Height = TkVariable.new;	
$Label_Width = TkVariable.new;
$Summary_Width = TkVariable.new;
$Description_Label_Width = TkVariable.new;
$Image_Label_Width = TkVariable.new;
$Frame_Colour = TkVariable.new;
$Label_Colour = TkVariable.new;
$Generate_Colour = TkVariable.new;
$x_off_motto = TkVariable.new;
$y_off_motto = TkVariable.new;
$x_off_charge = TkVariable.new;
$y_off_charge = TkVariable.new;
$x_off_Group_Name = TkVariable.new;
$y_off_Group_Name = TkVariable.new;
	
#-- Gobal Variable Define

$Motto_Font = TkFont.new('times 18 bold');
$font = TkFont.new('times 12 bold');
$Description_Font = TkFont.new('times 24 bold');
$Description_Font2 = TkFont.new('times 20 bold');


$Description.value = 'Select a choice to read its description';

$Description_Summary.value = 'Description summary';

$Shield_Yellow.value = "The colour gold on a group's shield or charge signifies that group members value being generous towards others. As well, the colour gold symbolizes that the group values engaging in behaviours that lead to self-improvement."; 
$Shield_Silver.value = "The colour silver on a group's shield or charge signifies that group members value working towards establishing peace and tranquillity in the world. As well, the colour silver symbolizes that the group values being sincere and honest towards others. ";
$Shield_Red.value = "The colour red on a group's shield or charge signifies that group members value having a warrior's strength. As well, the colour red symbolizes that the group values being gregarious and having a larger than life personality. ";
$Shield_Blue.value = "The colour blue on a group's shield or charge signifies that group members value wisdom and knowledge. As well, the colour blue symbolizes that the group values being loyal to their friends and family, and they are able to form valuable alliances through life. ";
$Shield_Black.value = "The colour black on a group's shield or charge signifies that group members value being stable and constant over time. As well, the colour black symbolizes that the group values being able to overcome grief and hardship. ";
$Shield_Green.value = "The colour green on a group's shield or charge signifies that the group values being hopeful and joyous throughout life. As well, the colour green symbolizes that the group values committed romantic relationships, and are able to resist temptations.";

$ChargeBoar.value = "A boar on a group's shield symbolizes that group members are physically strong and courageous. They enjoy feats that challenge their physical strength and their ferocity of spirit. ";
$ChargeGriffon.value = "A griffin on a group's shield symbolizes that group members have an optimal combination of agility, swiftness and mental strength. They use their cunningness and versatility to overcome the obstacles that arise in life. ";
$ChargeTiger.value = "A tiger on a group's shield symbolizes that group members are fearless and proud. They take pride in whatever they do and are achievement oriented.";
$ChargeTrefoil.value = "A trefoil on a group's shield symbolizes that group members are able to endure through life. They are able to make their own luck and find good fortune wherever life takes them. ";
$ChargeStag.value = "A stag on a group's shield symbolizes that group members are able to grow and improve themselves even in the face of adversity. They are constantly growing as individuals, and are able to recuperate when they struggle. ";
$ChargeSpider.value = "A spider on a group's shield symbolizes that group members are intelligent, have a sharp wit and tend to use their minds over their muscles. They are tenacious and their actions are always calculated and purpose driven. ";

$Description_Summary_gold.value = "Gold: Generosity, Mastery ";
$Description_Summary_silver.value = "Silver: Peacefulness, Honesty";
$Description_Summary_red.value =  "Red: Strength, Gregariousness";
$Description_Summary_blue.value = "Blue: Wisdom, Loyalty";
$Description_Summary_black.value = "Black: Stability, Resiliency";
$Description_Summary_green.value =  "Green: Joyfulness, Commitment";

$Charge_Summary_boar.value = "Boar: Physically Strong, Courageous";
$Charge_Summary_griffon.value = "Griffon: Swift, Versatile";
$Charge_Summary_trefoil.value = "Trefoil: Enduring, Lucky";
$Charge_Summary_stag.value = "Stag: Evolving, Regenerative";
$Charge_Summary_spider.value = "Spider: Intelligent, Purposeful ";
$Charge_Summary_tiger.value = "Tiger: Proud, Successful";

$Charge_Yellow = $Shield_Yellow; 
$Charge_Silver = $Shield_Silver;
$Charge_Red = $Shield_Red;
$Charge_Blue = $Shield_Blue;
$Charge_Black = $Shield_Black;
$Charge_Green = $Shield_Green;

#--- adjustments ------
$Frame_Colour.value = 'beige';
$Label_Colour.value = 'beige';
$Generate_Colour.value = 'grey';

$Motto_Entry_Length = 30; #specify the number of characters
#Charge placement: x_off 0 and y_off 75 for large picture #x_off 122 and y_off 140 for small pictures
#Motto placement: x_off 115 and y_off 675
$x_off_motto = 235;
$y_off_motto = 700;
$x_off_charge = 265;
$y_off_charge = 170;
$x_off_Group_Name = 235;
$y_off_Group_Name = 45;

$Description_Wrap_Length = 700;

$Button_Borderwidth = 4; #specify the border width of the choice buttons

$Description_Label_Height = 7;
$Description_Label_Width = 40;

$Summary_Height = 2;
$Summary_Width = 40;

$Image_Label_Height = 250;
$Image_Label_Width = 330;

$Button_Height = 1;
$Button_Width = 10;

$Label_Width = 12;
$Label_Height = 1;

#---------------------------------------------------------------------------------------------------------------------------
#-- IMAGE FRAME - ----------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------

Image_frame = TkFrame.new(root) do
	background $Frame_Colour.to_s
	borderwidth 5
	relief 'groove'
	height 800
	width 270
end
Image1_frame = TkFrame.new(Image_frame) do
	background $Frame_Colour.to_s
	borderwidth 5
	relief 'groove'
	height 400
	width 135
end
Image2_frame = TkFrame.new(Image_frame)do
	background $Frame_Colour.to_s
	borderwidth 5
	relief 'groove'
	height 400
	width 135
end
		Image_label = TkLabel.new(Image1_frame) do
			image $image0
			background 'white'
			borderwidth 5
			relief 'groove'
			height $Image_Label_Height
			width $Image_Label_Width
		end
		Description_label = TkLabel.new(Image2_frame) do
			font $Description_Font
			wraplength $Description_Wrap_Length
			textvariable $Description
			background $Label_Colour.to_s
			borderwidth 5
			relief 'groove'
			height $Description_Label_Height
			width $Description_Label_Width
		end
		Summary_Label = TkLabel.new(Image2_frame) do
			font $Description_Font
			textvariable $Description_Summary
			background $Label_Colour.to_s
			borderwidth 5
			relief 'groove'
			height $Summary_Height
			width $Summary_Width
		end
		Preview_Label = TkLabel.new(Image1_frame) do
			font $Description_Font2
			text 'Preview'
			background $Label_Colour.to_s
			borderwidth 5
			relief 'groove'
			height 1
		end
		TitleOfProgram = TkLabel.new(Image1_frame) do
			font $Description_Font2
			text 'Group Coat of Arms'
			background $Label_Colour.to_s
			borderwidth 5
			relief 'groove'
			height 1
		end 
		
		
#---------------------------------------------------------------------------------------------------------------------------
#-- SHIELD COLOUR FRAME - --------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------

Colour_Shield_frame = TkFrame.new(root) do
	background $Frame_Colour.to_s
	borderwidth 5
	relief 'groove'
	height 800
	width 270
end
		Colour_Shield_label = TkLabel.new(Colour_Shield_frame) do
			font $font
			text 'Shield Colour'
			background $Label_Colour.to_s
			borderwidth 5
			relief 'groove'
			height $Label_Height
			width $Label_Width
		end
				Shield_Colour_Yellow = TkRadioButton.new(Colour_Shield_frame) do
					font $font
					text 'Or(Gold)'
					background 'gold'
					activebackground 'gold'
					selectcolor 'gold'
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Shield_Colour
					value 'gold'
					command {$Description.value = $Shield_Yellow; $Description_Summary.value = $Description_Summary_gold;}
					anchor 'center'
					height $Button_Height
					width $Button_Width
				end
				Shield_Colour_Silver = TkRadioButton.new(Colour_Shield_frame) do
					font $font	
					text 'Argent(Silver)'
					background 'grey'
					activebackground 'grey'
					selectcolor 'grey'
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Shield_Colour
					value 'grey'
					command {$Description.value = $Shield_Silver; $Description_Summary.value = $Description_Summary_silver;}
					anchor 'center'
					height $Button_Height
					width $Button_Width
				end
				Shield_Colour_Red = TkRadioButton.new(Colour_Shield_frame) do
					font $font	
					text 'Gule(Red)'
					background 'red'
					activebackground 'red'
					selectcolor 'red'
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Shield_Colour
					value 'red'
					command {$Description.value = $Shield_Red; $Description_Summary.value = $Description_Summary_red;}
					anchor 'center'
					height $Button_Height
					width $Button_Width
				end
				Shield_Colour_Blue = TkRadioButton.new(Colour_Shield_frame) do
					font $font
					text 'Azue(Blue)'
					background 'Blue'
					activebackground 'blue'
					selectcolor 'blue'
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Shield_Colour
					value 'blue'
					command {$Description.value = $Shield_Blue; $Description_Summary.value = $Description_Summary_blue;}
					anchor 'center'
					height $Button_Height
					width $Button_Width
				end
				Shield_Colour_Black = TkRadioButton.new(Colour_Shield_frame) do
					font $font
					text 'Sable(Black)'
					background 'black'
					activebackground 'black'
					selectcolor 'black'
					borderwidth $Button_Borderwidth
					foreground 'white'
					activeforeground 'white'
					indicatoron false
					variable $Shield_Colour
					value 'black'
					command {$Description.value = $Shield_Black; $Description_Summary.value = $Description_Summary_black;}
					anchor 'center'
					height $Button_Height
					width $Button_Width
				end
				Shield_Colour_Green = TkRadioButton.new(Colour_Shield_frame) do
					font $font
					text 'Vert(Green)'
					background 'green'
					activebackground 'Green'
					selectcolor 'Green'
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Shield_Colour
					value 'green'
					command {$Description.value = $Shield_Green; $Description_Summary.value = $Description_Summary_green;}
					anchor 'center'
					height $Button_Height
					width $Button_Width
				end

#---------------------------------------------------------------------------------------------------------------------------
#-- CHARGE FRAME -----------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------

Charge_frame = TkFrame.new(root) do
	background $Frame_Colour.to_s
	borderwidth 5
	relief 'groove'
	height 800
	width 270
end
		Charge_label = TkLabel.new(Charge_frame) do
			font $font
			text 'Charge'
			background $Label_Colour.to_s
			borderwidth 5
			relief 'groove'
			height $Label_Height
			width $Label_Width
		end
				Charge1 = TkRadioButton.new(Charge_frame) do
						image $BoarIcon
						borderwidth $Button_Borderwidth
						indicatoron false
						variable $Charge
						value 'boar'
						command {$Description.value = $ChargeBoar; $Description_Summary.value = $Charge_Summary_boar;}
						anchor 'center'
					end

				Charge2 = TkRadioButton.new(Charge_frame) do
					image $GriffonIcon
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Charge
					value 'griffin'
					command {$Description.value = $ChargeGriffon; $Description_Summary.value = $Charge_Summary_griffon;}
					anchor 'center'
				end

				Charge3 = TkRadioButton.new(Charge_frame) do
							
					image $TigerIcon
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Charge
					value 'tiger'
					command {$Description.value = $ChargeTiger; $Description_Summary.value = $Charge_Summary_tiger;}
					anchor 'center'
				end

				Charge4 = TkRadioButton.new(Charge_frame) do
					image $TrefoilIcon
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Charge
					value 'trefoil'
					command {$Description.value = $ChargeTrefoil; $Description_Summary.value = $Charge_Summary_trefoil;}
					anchor 'center'
				end

				Charge5 = TkRadioButton.new(Charge_frame) do
					image $StagIcon
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Charge
					value 'stag'
					command {$Description.value = $ChargeStag; $Description_Summary.value = $Charge_Summary_stag;}
					anchor 'center'
				end

				Charge6 = TkRadioButton.new(Charge_frame) do
					image $SpiderIcon
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Charge
					value 'spider'
					command {$Description.value = $ChargeSpider; $Description_Summary.value = $Charge_Summary_spider;}
					anchor 'center'
				end
				
#---------------------------------------------------------------------------------------------------------------------------
#-- CHARGE COLOUR FRAME - --------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------

Colour_Charge_frame = TkFrame.new(root) do
	background $Frame_Colour.to_s
	borderwidth 5
	relief 'groove'
	height 800
	width 270
end
		Colour_Charge_label = TkLabel.new(Colour_Charge_frame) do
			font $font
			text 'Charge Colour'
			background $Label_Colour.to_s
			borderwidth 5
			relief 'groove'
			height $Label_Height
			width $Label_Width
		end

				Charge1_Colour = TkRadioButton.new(Colour_Charge_frame) do
					font $font
					text 'Or(Gold)'
					background 'Gold'
					activebackground 'Gold'
					selectcolor 'Gold'
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Charge_Colour
					value 'gold'
					command {$Description.value = $Charge_Yellow; $Description_Summary.value = $Description_Summary_gold;}
					anchor 'center'
					height $Button_Height
					width $Button_Width
				end
				Charge2_Colour = TkRadioButton.new(Colour_Charge_frame) do
					font $font
					text 'Argent(Silver)'
					background 'grey'
					activebackground 'grey'
					selectcolor 'grey'
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Charge_Colour
					value 'grey'
					command {$Description.value = $Charge_Silver; $Description_Summary.value = $Description_Summary_silver;}
					anchor 'center'
					height $Button_Height
					width $Button_Width
				end
				Charge3_Colour = TkRadioButton.new(Colour_Charge_frame) do
					font $font
					text 'Gules(Red)'
					background 'Red'
					activebackground 'Red'
					selectcolor 'Red'
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Charge_Colour
					value 'red'
					command {$Description.value = $Charge_Red; $Description_Summary.value = $Description_Summary_red;}
					anchor 'center'
					height $Button_Height
					width $Button_Width
				end
				Charge4_Colour = TkRadioButton.new(Colour_Charge_frame) do
					font $font
					text 'Azure(Blue)'
					background 'Blue'
					activebackground 'Blue'
					selectcolor 'blue'
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Charge_Colour
					value 'blue'
					command {$Description.value = $Charge_Blue; $Description_Summary.value = $Description_Summary_blue;}
					anchor 'center'
					height $Button_Height
					width $Button_Width
				end
				Charge5_Colour = TkRadioButton.new(Colour_Charge_frame) do
					font $font
					text 'Sable(Black)'
					background 'Black'
					activebackground 'Black'
					selectcolor 'Black'
					foreground 'white'
					activeforeground 'white'
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Charge_Colour
					value 'black'
					command {$Description.value = $Charge_Black; $Description_Summary.value = $Description_Summary_black;}
					anchor 'center'
					height $Button_Height
					width $Button_Width
				end
				Charge6_Colour = TkRadioButton.new(Colour_Charge_frame) do
					font $font
					text 'Vert(Green)'
					background 'Green'
					activebackground 'Green'
					selectcolor 'Green'
					borderwidth $Button_Borderwidth
					indicatoron false
					variable $Charge_Colour
					value 'green'
					command {$Description.value = $Charge_Green; $Description_Summary.value = $Description_Summary_green;}
					anchor 'center'
					height $Button_Height
					width $Button_Width
				end

#---------------------------------------------------------------------------------------------------------------------------
#-- MOTTO FRAME - ----------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------

Motto_frame = TkFrame.new(root) do
	background $Frame_Colour.to_s
	borderwidth 5
	relief 'groove'
	height 800
	width 270
end
		Motto_label_1 = TkLabel.new(Motto_frame) do
			font $font
			text 'Motto: '
			background $Label_Colour.to_s
			borderwidth 5
			relief 'groove'
			height $Label_Height
			width $Label_Width
		end
		
		Motto_label_2 = TkLabel.new(Motto_frame) do
			font $font
			text 'Group Name: '
			background $Label_Colour.to_s
			borderwidth 5
			relief 'groove'
			height $Label_Height
			width $Label_Width
		end
		
				$Motto1 = TkEntry.new(Motto_frame) do
					font $Motto_Font
					background 'white'
					borderwidth 5
					relief 'groove'
					width $Motto_Entry_Length
				end
				
				$Motto2 = TkEntry.new(Motto_frame) do
					font $Motto_Font
					background 'white'
					borderwidth 5
					relief 'groove'
					width $Motto_Entry_Length
				end
				
				$Motto1.focus;
				$Motto1.grid( :column => 2, :row => 1);
				$Motto2.grid( :column => 4, :row => 1);

#---------------------------------------------------------------------------------------------------------------------------
#-- GROUP NAME FRAME - -----------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------

Group_Name = TkFrame.new(root) do
	background $Frame_Colour.to_s
	borderwidth 5
	relief 'groove'
	height 800
	width 270
end

#---------------------------------------------------------------------------------------------------------------------------
#-- GENERATE BUTTON FRAME - ------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------

Button_frame = TkFrame.new(root) do
	background $Frame_Colour.to_s
	borderwidth 5
		relief 'groove'
		height 800
		width 270
end

def generate_cote_of_arms 
	
	$CT = Time.new;
	
	File.open('Motto1.txt', 'w') do |f1|  
		f1.puts $Motto1.get;  
	end  
	
	File.open('Motto2.txt', 'w') do |f1|  
		f1.puts $Motto2.get;  
	end  
	
	system '%CD%/Programs/IrFanView/i_view32.exe %CD%\Motto1.txt /convert=%CD%\Motto1.png';
	system '%CD%/Programs/IrFanView/i_view32.exe %CD%\Motto1.png /resize=(600,42) /convert=%CD%\Motto1.png';
	
	system '%CD%/Programs/IrFanView/i_view32.exe %CD%\Motto2.txt /convert=%CD%\Motto2.png';
	system '%CD%/Programs/IrFanView/i_view32.exe %CD%\Motto2.png /resize=(600,42) /convert=%CD%\Motto2.png';
	
	system 'del "Motto1.txt"';
	system 'del "Motto2.txt"';
	
	if ($Shield_Colour == 'gold') 
		shield_path = 'Images/Shields/ShieldYellow.png';
		else
			if ($Shield_Colour == 'grey') 
				shield_path = 'Images/Shields/ShieldSilver.png';
				else
					if ($Shield_Colour == 'red') 
						shield_path = 'Images/Shields/ShieldRed.png';
						else
							if ($Shield_Colour == 'blue') 
								shield_path = 'Images/Shields/ShieldBlue.png';
								else
									if ($Shield_Colour == 'black') 
										shield_path = 'Images/Shields/ShieldBlack.png';
										else
											if ($Shield_Colour == 'green') 
												shield_path = 'Images/Shields/ShieldGreen.png';
												else
													shield_path = 'Images/Shields/None.png';	#blank
											end
									end
							end
					end
			end
	end
	
	if ($Charge == 'boar')
		if ($Charge_Colour == 'gold') 
			charge_path = 'Images/Charges/BoarYellow.png';
			else
				if ($Charge_Colour == 'grey') 
					charge_path = 'Images/Charges/BoarSilver.png';
					else
						if ($Charge_Colour == 'red') 
							charge_path = 'Images/Charges/BoarRed.png';
							else
								if ($Charge_Colour == 'blue') 
									charge_path = 'Images/Charges/BoarBlue.png';
									else
										if ($Charge_Colour == 'black') 
											charge_path = 'Images/Charges/BoarBlack.png';
											else
												if ($Charge_Colour == 'green') 
													charge_path = 'Images/Charges/BoarGreen.png';
													else
														charge_path = 'Images/Charges/None.png'	;
												end
										end
								end
						end
				end
		end
		else
			if ($Charge == 'griffin')
				if ($Charge_Colour == 'gold') 
					charge_path = 'Images/Charges/GriffinYellow.png';
					else
						if ($Charge_Colour == 'grey') 
							charge_path = 'Images/Charges/GriffinSilver.png';
							else
								if ($Charge_Colour == 'red') 
									charge_path = 'Images/Charges/GriffinRed.png';
									else
										if ($Charge_Colour == 'blue') 
											charge_path = 'Images/Charges/GriffinBlue.png';
											else
												if ($Charge_Colour == 'black') 
													charge_path = 'Images/Charges/GriffinBlack.png';
													else
														if ($Charge_Colour == 'green') 
															charge_path = 'Images/Charges/GriffinGreen.png';
															else
																charge_path = 'Images/Charges/None.png';	
														end
												end
										end
								end
						end
				end
				else 
					if ($Charge == 'tiger')
						if ($Charge_Colour == 'gold') 
							charge_path = 'Images/Charges/TigerYellow.png';
							else
								if ($Charge_Colour == 'grey') 
									charge_path = 'Images/Charges/TigerSilver.png';
									else
										if ($Charge_Colour == 'red') 
											charge_path = 'Images/Charges/TigerRed.png';
											else
												if ($Charge_Colour == 'blue') 
													charge_path = 'Images/Charges/TigerBlue.png';
													else
														if ($Charge_Colour == 'black') 
															charge_path = 'Images/Charges/TigerBlack.png';
															else
																if ($Charge_Colour == 'green') 
																	charge_path = 'Images/Charges/TigerGreen.png';
																	else
																		charge_path = 'Images/Charges/None.png';
																end
														end
												end
										end
								end
						end
						else
							if ($Charge == 'stag')
								if ($Charge_Colour == 'gold') 
									charge_path = 'Images/Charges/StagYellow.png';
									else
										if ($Charge_Colour == 'grey') 
											charge_path = 'Images/Charges/StagSilver.png';
											else
												if ($Charge_Colour == 'red') 
													charge_path = 'Images/Charges/StagRed.png';
													else
														if ($Charge_Colour == 'blue') 
															charge_path = 'Images/Charges/StagBlue.png';
															else
																if ($Charge_Colour == 'black') 
																	charge_path = 'Images/Charges/StagBlack.png';
																	else
																		if ($Charge_Colour == 'green') 
																			charge_path = 'Images/Charges/StagGreen.png';
																			else
																				charge_path = 'Images/Charges/None.png'	;
																		end
																end
														end
												end
										end
								end
								else
									if ($Charge == 'spider')
										if ($Charge_Colour == 'gold') 
											charge_path = 'Images/Charges/SpiderYellow.png';
											else
												if ($Charge_Colour == 'grey') 
													charge_path = 'Images/Charges/SpiderSilver.png';
													else
														if ($Charge_Colour == 'red') 
															charge_path = 'Images/Charges/SpiderRed.png';
															else
																if ($Charge_Colour == 'blue') 
																	charge_path = 'Images/Charges/SpiderBlue.png';
																	else
																		if ($Charge_Colour == 'black') 
																			charge_path = 'Images/Charges/SpiderBlack.png';
																			else
																				if ($Charge_Colour == 'green') 
																					charge_path = 'Images/Charges/SpiderGreen.png';
																					else
																						charge_path = 'Images/Charges/None.png'	;
																				end
																		end
																end
														end
												end
										end
										else
											if ($Charge == 'lion')
												if ($Charge_Colour == 'gold') 
													charge_path = 'Images/Charges/LionYellow.png';
													else
														if ($Charge_Colour == 'grey') 
															charge_path = 'Images/Charges/LionSilver.png';
															else
																if ($Charge_Colour == 'red') 
																	charge_path = 'Images/Charges/LionRed.png';
																	else
																		if ($Charge_Colour == 'blue') 
																			charge_path = 'Images/Charges/LionBlue.png';
																			else
																				if ($Charge_Colour == 'black') 
																					charge_path = 'Images/Charges/LionBlack.png';
																					else
																						if ($Charge_Colour == 'green') 
																							charge_path = 'Images/Charges/LionGreen.png';
																							else
																								charge_path = 'Images/Charges/None.png'	;
																						end
																				end
																		end
																end
														end
												end
												else
													if ($Charge == 'trefoil')
														if ($Charge_Colour == 'gold') 
															charge_path = 'Images/Charges/TrefoilYellow.png';
															else
																if ($Charge_Colour == 'grey') 
																	charge_path = 'Images/Charges/TrefoilSilver.png';
																	else
																		if ($Charge_Colour == 'red') 
																			charge_path = 'Images/Charges/TrefoilRed.png';
																			else
																				if ($Charge_Colour == 'blue') 
																					charge_path = 'Images/Charges/TrefoilBlue.png';
																					else
																						if ($Charge_Colour == 'black') 
																							charge_path = 'Images/Charges/TrefoilBlack.png';
																							else
																								if ($Charge_Colour == 'green') 
																									charge_path = 'Images/Charges/TrefoilGreen.png';
																									else
																										charge_path = 'Images/Charges/None.png';	
																								end
																						end
																				end
																		end
																end
														end
														else
															charge_path ='Images/Charges/None.png'; #blank
													end
											end
									end
							end
					end
			end
	end
	
	motto1 = ChunkyPNG::Canvas.from_file('Motto1.png');
	motto2 = ChunkyPNG::Canvas.from_file('Motto2.png');
	shield = ChunkyPNG::Canvas.from_file(shield_path);
	charge = ChunkyPNG::Canvas.from_file(charge_path);
	coa = shield.compose!(charge, offset_x = $x_off_charge, offset_y = $y_off_charge); 
	coa = coa.compose!(motto1, offset_x = $x_off_motto, offset_y = $y_off_motto); 
	coa = coa.compose!(motto2, offset_x = $x_off_Group_Name, offset_y = $y_off_Group_Name);
	coa.save('CoatOfArms.png');
	$Groupname = $Motto2.get.to_s;
	sp = "Group Data/" + $Groupname.to_s + ' ' +  $CT.hour.to_s + 'h' + $CT.min.to_s + 'm' + $CT.sec.to_s + 's' + ' ' +  $CT.day.to_s + "-" + $CT.month.to_s + "-" + $CT.year.to_s + '.png'
	coa.save(sp);
	system '%CD%/Programs/IrFanView/i_view32.exe %CD%\CoatOfArms.png /resize=(310,310) /aspectratio /resample /convert=%CD%\CoatOfArmsShrunk.png';
	system 'del "Motto1.png"';
	system 'del "Motto2.png"';
	$image0.file = "CoatOfArmsShrunk.png";

end

Generate_Button = TkButton.new(Button_frame) do
	font $font
	text 'Generate Coat of Arms Preview'
	background $Generate_Colour.to_s
	borderwidth 5
	relief 'groove'
	command {generate_cote_of_arms;}
end

Finalize_Button = TkButton.new(Button_frame) do
	font $font
	text 'Finalize Coat of Arms'
	background $Generate_Colour.to_s
	borderwidth 5
	relief 'groove'
	command {system '%CD%/Programs/IrFanView/i_view32.exe %CD%\CoatOfArms.png';}
end

#---------------------------------------------------------------------------------------------------------------------------
#-- GRID PLACEMENT ---------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------

Image_frame.grid( :column => 1, :row => 1, :sticky => 'nsew');
Image1_frame.grid( :column => 1, :row => 1, :sticky => 'nsew');
Image2_frame.grid( :column => 2, :row => 1, :sticky => 'nsew');
Colour_Shield_frame.grid( :column => 1, :row => 2, :sticky => 'nsew');
Charge_frame.grid( :column => 1, :row => 3, :sticky => 'nsew');
Colour_Charge_frame.grid( :column => 1, :row => 4, :sticky => 'nsew');
Motto_frame.grid( :column => 1, :row => 5, :sticky => 'nsew');
Button_frame.grid( :column => 1, :row => 6, :sticky => 'nsew');

TitleOfProgram.grid( :column => 1, :row => 1, :sticky => 'nsew');
Image_label.grid( :column => 1, :row => 2, :sticky => 'nsew');
Preview_Label.grid( :column => 1, :row => 3, :sticky => 'nsew');
Description_label.grid( :column => 1, :row => 1, :sticky => 'n');
Summary_Label.grid( :column => 1, :row => 2, :sticky => 'n');
Colour_Shield_label.grid( :column => 1, :row => 1);
Charge_label.grid( :column => 1, :row => 1);
Colour_Charge_label.grid( :column => 1, :row => 1);
Motto_label_1.grid( :column => 1, :row => 1);
Motto_label_2.grid( :column => 3, :row => 1);

Shield_Colour_Yellow.grid( :column => 2, :row => 1);
Shield_Colour_Silver.grid( :column => 3, :row => 1);
Shield_Colour_Red.grid( :column => 4, :row => 1);
Shield_Colour_Blue.grid( :column => 5, :row => 1);
Shield_Colour_Black.grid( :column => 6, :row => 1);
Shield_Colour_Green.grid( :column => 7, :row => 1);

Charge1.grid( :column => 2, :row => 1);
Charge2.grid( :column => 3, :row => 1);
Charge3.grid( :column => 4, :row => 1);
Charge4.grid( :column => 5, :row => 1);
Charge5.grid( :column => 6, :row => 1);
Charge6.grid( :column => 7, :row => 1);

Charge1_Colour.grid( :column => 2, :row => 1);
Charge2_Colour.grid( :column => 3, :row => 1);
Charge3_Colour.grid( :column => 4, :row => 1);
Charge4_Colour.grid( :column => 5, :row => 1);
Charge5_Colour.grid( :column => 6, :row => 1);
Charge6_Colour.grid( :column => 7, :row => 1);

Generate_Button.grid( :column => 1, :row => 1, :sticky => 'w');
Finalize_Button.grid( :column => 2, :row => 1, :sticky => 'e');

#-- Add padding around each frame
TkWinfo.children(Image_frame).each {|w| TkGrid.configure w, :padx => 1, :pady => 1};
TkWinfo.children(Colour_Shield_frame).each {|w| TkGrid.configure w, :padx => 5, :pady => 5};
TkWinfo.children(Charge_frame).each {|w| TkGrid.configure w, :padx => 5, :pady => 5};
TkWinfo.children(Colour_Charge_frame).each {|w| TkGrid.configure w, :padx => 5, :pady => 5};
TkWinfo.children(Motto_frame).each {|w| TkGrid.configure w, :padx => 5, :pady => 5};

#-- To go full screen -----
#root.withdraw
#root.overrideredirect = true
#root.deiconify
#root.geometry = "#{root.winfo_screenwidth}x#{root.winfo_screenheight}+0+ 0"
#Tk.root.state = 'zoomed'
#---------------------------

#-- Escape exits the program -- Make a button later
root.bind('Escape') {exit};

#-- Start program loop	
Tk.mainloop;